@extends('admin.base')

@section('content')
    <div class="layui-card">
        <div class="layui-card-body">
            <table id="dataTable" lay-filter="dataTable"></table>
            <!-- 表格头部 -->
            <script type="text/html" id="toolbarDemo">
                <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                    @can('complain.type.store')
                    <div class="layui-inline" lay-event="add"><i class="layui-icon layui-icon-add-1"></i></div>
                    @endcan
                    @can('complain.type.del')
                    <div class="layui-inline" lay-event="delete"><i class="layui-icon layui-icon-delete"></i></div>
                    @endcan
                    <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
                </div>
            </script>
            <!-- 操作 -->
            <script type="text/html" id="options">
                <div class="layui-btn-group">
                    @can('complain.type.store')
                    <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
                    @endcan
                    @can('complain.type.del')
                    <a class="layui-btn layui-btn-danger layui-btn-xs " lay-event="del">删除</a>
                    @endcan
                </div>
            </script>
        </div>
    </div>
@endsection

@section('script')
@can('complain.type')
<script>
layui.use(['layer', 'table', 'form','laydate'], function() {
    var $ = layui.jquery;
    var layer = layui.layer;
    var form = layui.form;
    var table = layui.table;
    var laydate = layui.laydate;
    var util = layui.util;

    //用户表格初始化
    var dataTable = table.render({
        elem: '#dataTable',
        height: 'full-50',
        toolbar: '#toolbarDemo',
        url: "{{ route('complain.type.data') }}",
        page: true, //开启分页
        cols: [[ //表头
                {checkbox: true}, 
                {field: 'id', title: 'ID', sort: true,align: 'center', minWidth: 100,templet: function(d){ return '<i><b>'+d.id+'</b></i>';}},
                {field: 'title',title: '分类名称',align: 'center',minWidth: 200,templet: function(d){ return '<i><b>'+d.title+'</b></i>';}},
                {field: 'sort', title: '排序',align: 'center',minWidth: 200,templet: function(d){ return '<i><b>'+d.sort+'</b></i>';}},
                {field: 'created_at',minWidth: 200,title: '创建时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}},
                {field: 'updated_at',minWidth: 200,title: '更新时间',align: 'center',templet: function(d) {return util.toDateString(d.updated_at*1000);}},
                {title: '操作',align: 'center',toolbar: '#options',minWidth: 200,fixed: 'right'}
            ]],
        // 设置操作高度问题
        done: function () {
            //设置工具栏表头高度
            $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
            //设置工具栏按钮栏高度
            $(".layui-table").eq(1).find("tr").each(function(index,ele){
                $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
            });
        }
    });

    // 头部工具
    table.on('toolbar(dataTable)', function (obj) {
        switch (obj.event) {
            // 添加
            case 'add':
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['40%', '40%'],
                    content: "{{route('complain.type.store')}}"
                });
                break;
            // 批量删除
            case 'delete':
                var ids = [];
                var hasCheck = table.checkStatus('dataTable');
                var hasCheckData = hasCheck.data;
                if (hasCheckData.length > 0) {
                    $.each(hasCheckData, function(index, element) {
                        ids.push(element.id)
                    })
                }
                if (ids.length > 0) {
                    layer.confirm('确认删除吗？', function(index) {
                        layer.close(index);
                        var load = layer.load();
                        $.post("{{ route('complain.type.del') }}", {
                            _method: 'delete',
                            ids: ids
                        }, function(res) {
                            // 删除询问按钮
                            layer.close(load);
                            if (res.code == 200) {
                                // 关闭当前页 刷新父页面
                                layer.msg(res.msg, { icon: 1, time:500}, function() {
                                    table.reload('dataTable');
                                })
                            } else {
                                layer.msg(res.msg, {icon: 2})
                            }
                        });
                    })
                } else {
                    layer.msg('请选择删除项', {icon: 2})
                }
                break;
            // 刷新
            case 'refresh':
                dataTable();
                break;
            }
    });

    //监听工具条
    table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
        var data = obj.data,      // data 数据
            layEvent = obj.event; //获得 lay-event 对应的值
        if (layEvent === 'del') {
            // 单挑删除
            layer.confirm('确认删除吗？', function(index) {
                    layer.close(index);
                var load = layer.load();
                $.post("{{ route('complain.type.del') }}", {
                    _method: 'delete',
                    ids: [data.id]
                }, function(res) {
                    // 删除询问按钮
                    layer.close(load);
                    if (res.code == '200') {
                        // 弹窗并删除行
                        layer.msg(res.msg , { icon: 1, time:500}, function() {
                            obj.del();
                        })
                    } else {
                        // 失败弹窗
                        layer.msg(res.msg, {icon: 2})
                    }
                });
            });
        } else if (layEvent === 'edit') {
            // 编辑
            layer.open({
                type: 2,
                shade: 0.8,
                area: ['40%', '40%'],
                content: "{{route('complain.type.store')}}?id="+data.id
            });
        }
    });
})
</script>
@endcan
@endsection