@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        <h2>添加/编辑轮播图</h2>
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">缩略图</label>
                <div class="layui-input-block">
                    <div class="upload_thumb" id="thumb" name="thumb" src="{{$model->thumb}}"></div>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">轮播图分类</label>
                <div class="layui-input-block">
                    <select name="cat_id">
                        @foreach($cat as $k=>$v)
                        <option value="{{$k}}" {{ $model->id && $k == $model->cat_id ? 'selected' : '' }}>{{$v}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">轮播图标题</label>
                <div class="layui-input-block">
                    <input type="text" name="title" value="{{$model->title}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">跳转方式</label>
                <div class="layui-input-block">
                    @foreach($url_type as $k=>$v)
                    <input type="radio" name="url_type" lay-filter="url_type" value="{{$k}}" title="{{$v}}" @if(($model->id && $model->url_type==$k) || (!$model->id && $k==1)) checked @endif >
                    @endforeach
                </div>
            </div>

            <div class="editor" style="display:none">
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">详情</label>
                    <div class="layui-input-block">
                        <!-- 百度编辑器的容器 -->
                        <script id="ueditor" name="editor" type="text/plain">{!!$model->editor!!}</script>
                    </div>
                </div>
            </div>

            <div class="links" style="display:none">
                <div class="layui-form-item">
                    <label for="" class="layui-form-label">跳转链接</label>
                    <div class="layui-input-block">
                        <input type="text" name="links" value="{{$model->links}}" class="layui-input">
                        <div class="layui-form-mid layui-word-aux">
                            <span>1.内部链接</span><br>
                            &emsp;&emsp;<span>1.抽盒页面：/pages/box/box</span><br>
                            &emsp;&emsp;<span>2.幸运盲盒：/package/index/luck-box</span><br>
                            &emsp;&emsp;<span>3.购物订单：/package/mine/mall-order</span><br>
                            &emsp;&emsp;<span>4.置换商店：/package/index/exchange</span><br>
                            &emsp;&emsp;<span>5.盒子详情：/package/box/box-detail?id={换成数据ID}</span><br>
                            &emsp;&emsp;<span>6.商城详情：/package/mall/mall-detail?id={换成数据ID}</span><br>
                            <span>2.外部链接要填写完整路径（例：https://www.baidu.com）</span>
                        </div>
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <label class="layui-form-label">启用/禁用</label>
                <div class="layui-input-block">
                    <input type="checkbox" name="status" lay-skin="switch" lay-filter="switchTest" lay-text="启用|禁用" @if($model->status ==1) checked @endif>
                    <div class="layui-unselect layui-form-switch layui-form-onswitch" lay-skin="_switch">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    layui.use(['element', 'form','util'], function() {
        var form = layui.form
        var util = layui.util
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('operate.banners.store')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg, {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });

        // radio 事件
        form.on("radio(url_type)", function(data){
            var url_type = this.value;
            if (url_type == 1) {
                $('.editor,.links').css('display', 'none');
            } else if (url_type == 2) {
                $('.links').css('display', 'none');
                $('.editor').css('display', 'block');
            }else if (url_type == 3) {
                $('.links').css('display', 'block');
                $('.editor').css('display', 'none');
            } else if (url_type == 4) {
                $('.links').css('display', 'block');
                $('.editor').css('display', 'none');
            }
        });
    })
</script>
<script>
    $(function() {
        var url_type = $("input[name='url_type']:checked").val()
        if (url_type == 1) {
            $('.editor,.links').css('display', 'none');
        } else if (url_type == 2) {
            $('.links').css('display', 'none');
            $('.editor').css('display', 'block');
        }else if (url_type == 3) {
            $('.links').css('display', 'block');
            $('.editor').css('display', 'none');
        } else if (url_type == 4) {
            $('.links').css('display', 'block');
            $('.editor').css('display', 'none');
        }
    })
</script>
@endsection