@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        <h2>添加/编辑商品</h2>
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">商品图</label>
                <div class="layui-input-block">
                    <div class="upload_thumb" id="thumb" name="thumb" data-width="100" src="@if($model->thumb) {{implode(',',$model->thumb)}} @endif" data-num="10"></div>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">商品分类</label>
                <div class="layui-input-block">
                    <select name="cat_id">
                        @foreach($cat as $k=>$v)
                        <option value="{{$v->id}}" {{ $model->id && $v->id == $model->cat_id ? 'selected' : '' }}>{{$v->title}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">商品品牌</label>
                <div class="layui-input-block">
                    <select name="brand_id">
                        <option value="">请选择状态</option>
                        @foreach($brand as $k=>$v)
                        <option value="{{$v->id}}" {{ $model->id && $v->id == $model->brand_id ? 'selected' : '' }}>{{$v->title}}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">商品标题</label>
                <div class="layui-input-block">
                    <input type="text" name="title" value="{{$model->title}}" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">商品排序</label>
                <div class="layui-input-block">
                    <input type="number" name="sort" value="{{$model->sort??0}}" class="layui-input">
                </div>
            </div>

            <!-- 规格类型 -->
            {{-- <div id="fairy-is-attribute" class="layui-input-block"></div> --}}
            <input type="hidden" name="is_attribute" value="1">
            <!--商品规格表-->
            <div id="fairy-spec-table" class="layui-input-block"></div>
            <!--商品库存表-->
            <div id="fairy-sku-table" class="layui-input-block"></div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">详情</label>
                <div class="layui-input-block">
                    <!-- 百度编辑器的容器 -->
                    <script id="ueditor" name="editor" type="text/plain">{!!$model->editor!!}</script>
                </div>
            </div>

            <div class="layui-form-item">
                <label class="layui-form-label">开关-默认关</label>
                <div class="layui-input-block">
                    <input type="checkbox" name="status" lay-skin="switch" lay-filter="switchTest" lay-text="启用|禁用" @if($model->status ==1) checked @endif>
                    <div class="layui-unselect layui-form-switch layui-form-onswitch" lay-skin="_switch">
                    </div>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    layui.config({
        base: '/static/admin/layuiadmin/lay-module/', // 设定扩展的 layui 模块的所在目录，一般用于外部模块扩展
    }).use(['form', 'skuTable'], function () {
        var form = layui.form, skuTable = layui.skuTable;

        //注意！！！ 注意！！！ 注意！！！
        //如果配置了相关接口请求的参数，请置本示例于服务器中预览，不然会有浏览器跨域问题
        var obj = skuTable.render({
            //规格类型 0统一规格 1多规格
            isAttributeValue: "{{$model->is_attribute?:1}}",
            //规格类型容器id
            isAttributeElemId: 'fairy-is-attribute',
            //规格表容器id
            specTableElemId: 'fairy-spec-table',
            //sku表容器id
            skuTableElemId: 'fairy-sku-table',
            //规格拖拽排序
            sortable: true,
            //sku表相同属性值是否合并行
            rowspan: true,
            //规格拖拽排序
            sortable: true,
            //请求成功返回状态码值
            requestSuccessCode: 200,
            //上传接口地址
            //接口要求返回格式参考 upload.json
            uploadUrl: '{{route("admin.uploads.image")}}',
            //统一规格配置项
            singleSkuTableConfig: {
                thead: [
                    {title: '原价(元)', icon: 'layui-icon-cols'},
                    {title: '现价(元)', icon: 'layui-icon-cols'},
                    {title: '销量', icon: 'layui-icon-cols'},
                    {title: '库存', icon: 'layui-icon-cols'},
                ],
                tbody: [
                    {type: 'input', field: 'old_price', value: '', verify: 'required|number', reqtext: '原价不能为空'},
                    {type: 'input', field: 'price', value: '0', verify: 'required|number', reqtext: '现价不能为空'},
                    {type: 'input', field: 'sales', value: '0', verify: 'required|number', reqtext: '销量不能为空'},
                    {type: 'input', field: 'stock', value: '0', verify: 'required|number', reqtext: '库存不能为空'},
                ]
            },
            //多规格配置项
            multipleSkuTableConfig: {
                thead: [
                    {title: '图片', icon: ''},
                    {title: '原价(元)', icon: 'layui-icon-cols'},
                    {title: '现价(元)', icon: 'layui-icon-cols'},
                    {title: '销量', icon: 'layui-icon-cols'},
                    {title: '库存', icon: 'layui-icon-cols'},
                    {title: '状态', icon: ''},
                ],
                tbody: [
                    {type: 'image', field: 'thumb', value: '', verify: '', reqtext: ''},
                    {type: 'input', field: 'old_price', value: '', verify: 'required|number', reqtext: '原价不能为空'},
                    {type: 'input', field: 'price', value: '0', verify: 'required|number', reqtext: '现价不能为空'},
                    {type: 'input', field: 'sales', value: '0', verify: 'required|number', reqtext: '销量不能为空'},
                    {type: 'input', field: 'stock', value: '0', verify: 'required|number', reqtext: '库存不能为空'},
                    {
                        type: 'select',
                        field: 'status',
                        option: [{key: '启用', value: '1'}, {key: '禁用', value: '2'}],
                        verify: '',
                        reqtext: ''
                    },
                ]
            },
            //商品id 配合specDataUrl和skuDataUrl使用
            productId: '{{$model->id}}',
            //获取规格数据接口地址，如果为空或者不配置则使用 specData 参数配置
            specDataUrl: '{{route("shop.goods.specData")}}',
            //sku数据
            skuDataUrl: '{{route("shop.goods.skuData")}}',
        });

        // Form 提交
        layui.use(['element', 'form','util'], function() {
            var form = layui.form
            var util = layui.util
            //监听提交
            form.on('submit(formDemo)', function(data) {
                // 禁用提交按钮
                var DISABLED = 'layui-btn-disabled';
                $('.preservation').addClass(DISABLED);
                $('.preservation').attr('disabled', 'disabled');
                if (data.field.is_attribute == 1) {
                    //获取规格数据
                    var state = Object.keys(data.field).some(function (item, index, array) {
                        return item.startsWith('skus');
                    });
                    if(!state){
                        layer.msg('sku表数据不能为空', {icon: 5, anim: 6});
                        return false;
                    }
                }
                data.field.spec = obj.getSpecData();
                $.ajax({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    url: "{{route('shop.goods.store')}}",
                    type: 'POST',
                    data: data.field,
                    async: false,
                    dataType: "json",
                    // 接口成功请求之后的逻辑
                    success: function(res) {
                        if (res['code'] == 200) {
                            // 弹窗
                            layer.msg(res.msg, { icon: 1, time:500},function(){
                                var index = parent.layer.getFrameIndex(window.name); 
                                parent.layui.table.reload('dataTable');
                                parent.layer.close(index);
                            });
                        } else {
                            layer.msg(res.msg, {icon: 2});
                            // 单击之后提交按钮不可选,防止重复提交
                            $('.preservation').removeClass(DISABLED);
                            $('.preservation').removeAttr('disabled');
                        }
                    },
                    // 服务器错误
                    error: function(res) {
                        // 弹窗
                        layer.msg('服务器错误', {icon: 2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                });
                return false;
            });
        })
    });
</script>
@endsection