@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header layuiadmin-card-header-auto">
        <!-- form -->
        <div class="layui-form">

            <div class="layui-input-inline">
                <input type="text" name="id" id="id" value="{{request()->id}}" placeholder="请输入用户ID" class="layui-input">
            </div>&emsp;

            <!--<div class="layui-input-inline">-->
            <!--    <input type="text" name="mobile" id="mobile" placeholder="请输入用户手机号" class="layui-input">-->
            <!--</div>&emsp;-->
            
            <div class="layui-input-inline" style="width:182px;">
                <select name="status" id="status">
                    <option value="">请选择收入或支出</option>
                    <option value="1">收入</option>
                    <option value="2">支出</option>
                </select>
            </div>&emsp;

            <div class="layui-inline" id="datesection">
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="start_time" id="start_time" class="layui-input" placeholder="开始日期">
                </div>
                -
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="end_time" id="end_time" class="layui-input" placeholder="结束日期">
                </div>
            </div>
            <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
            </button>
        </div>
    </div>

    <div class="layui-card-body">
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 头像 -->
        <script type="text/html" id="templet_thumb">
            <img class="pimg" src="@{{d.userinfo.avatar}}" style="width: 40px;height:40px;border-radius: 20px;object-fit: contain;">
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            
        </script>
    </div>

</div>
@endsection

@section('script')
@can('stats.coin')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-130',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{!! route('stats.coin.data',['id'=>request()->id]) !!}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.id+'</b></i>';}},
                    {field: 'user_id',title: '用户ID',align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.user_id+'</b></i>';}},
                    {field: 'nickName',title: '昵称',align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.userinfo.nickName+'</b></i>';}},
                    {field: 'before',title: '改变之前金额',align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.before+'</b></i>';}},
                    {field: 'change',title: '改变金额',align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.change+'</b></i>';}},
                    {field: 'after',title: '改变之后台金额',align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.after+'</b></i>';}},
                    {field: 'desc',title: '描述',align: 'center',width: 150,templet: function(d){ return '<i><b>'+d.desc+'</b></i>';}},
                    {field: 'created_at',width: 200,title: '时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}}, 
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'edit') {
               
            }
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    id: $("#id").val(),
                    mobile: $("#mobile").val(),
                    status: $("#status").val(),
                    start_time: $("#start_time").val(),
                    end_time: $("#end_time").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
        })
    })
</script>
@endcan
@endsection