@extends('admin.base')

@section('content')
<div class="layui-card">

    <div class="layui-card-body">
        <!-- 表格 -->
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->
        <script type="text/html" id="options">
            <div class="layui-btn-group">
                @can('sys.rule.store')
                <a class="layui-btn layui-btn-xs" lay-event="edit">编辑</a>
                @endcan
            </div>
        </script>
    </div>

</div>
@endsection

@section('script')
@can('sys.rule')
<script>
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-50',
            limits: [20,50,100,200,500],
            limit: 20,
            toolbar: '#toolbarDemo',
            url: "{{ route('sys.rule.data') }}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.id+'</b></i>';}},
                    {field: 'title',title: '规则标题',align: 'center',minWidth: 200,templet: function(d){ return '<i><b>'+d.title+'</b></i>';}},
                    {field: 'desc',title: '规则备注',align: 'center',minWidth: 400,templet: function(d){ return '<i><b>'+d.desc+'</b></i>';}},
                    {field: 'created_at',minWidth: 300,title: '创建时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}}, 
                    {field: 'updated_at',minWidth: 300,title: '更新时间',align: 'center',templet: function(d) {return util.toDateString(d.updated_at*1000);}}, 
                    {title: '操作',align: 'center',toolbar: '#options',minWidth: 200,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,      // data 数据
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'del') {
                
            } else if (layEvent === 'edit') {
                // 编辑
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '90%'],
                    content: "{{route('sys.rule.store')}}?id="+data.id
                });
            }
        });
    })
</script>
@endcan
@endsection