@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        @if($money_type==1)
        <h2>用户余额编辑</h2>
        @endif
        @if($money_type==2)
        <h2>用户积分编辑</h2>
        @endif
        @if($money_type==3)
        <h2>用户购物金编辑</h2>
        @endif
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">
            <input type="hidden" name="money_type" value="{{$money_type}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">原有金额</label>
                <div class="layui-input-block">
                    @if($money_type==1)
                    <input type="number" value="{{$model->userinfo->money}}" class="layui-input" disabled>
                    @endif
                    @if($money_type==2)
                    <input type="number" value="{{$model->userinfo->coin}}" class="layui-input" disabled>
                    @endif
                    @if($money_type==3)
                    <input type="number" value="{{$model->userinfo->gold}}" class="layui-input" disabled>
                    @endif
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">操作金额</label>
                <div class="layui-input-block" >
                    <input type="number" name= "money" value="" class="layui-input">
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">操作方式</label>
                <div class="layui-input-block">
                    <input type="radio" name="type" value="1" title="添加" checked>
                    <input type="radio" name="type" value="2" title="减少">
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                </div>
            </div>

        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    layui.use(['element', 'form'], function() {
        var form = layui.form
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('users.users.edit_money')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg,{icon:2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    layer.msg('服务器错误',{icon:2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection