@extends('admin.base')

@section('content')
<div class="layui-card">
    <div class="layui-card-header  layuiadmin-card-header-auto">
        <h2>添加/编辑发货状态</h2>
    </div>
    <div class="layui-card-body">
        <form class="layui-form" method="post">
            {{csrf_field()}}
            <input type="hidden" name="id" value="{{$model->id}}">

            <div class="layui-form-item">
                <label for="" class="layui-form-label">姓名：</label>
                <div class="layui-input-block">
                    <input type="text" name="name" value="{{$model->shipinfo->name}}" class="layui-input" autoComplete='off'>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">手机号</label>
                <div class="layui-input-block">
                    <input type="text" name="mobile" value="{{$model->shipinfo->mobile}}" class="layui-input" autoComplete='off'>
                </div>
            </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">详细地址</label>
                <div class="layui-input-block">
                    <input type="text" name="address" value="{{$model->shipinfo->address}}" class="layui-input" autoComplete='off'>
                </div>
            </div>

            <div class="layui-form-item">
                 <label for="" class="layui-form-label">快递类型</label>
                 <div class="layui-input-block">
                     <select name="delivery_id">
                        <option value="">--请选择--</option>
                        @foreach($delivery as $v)
                        <option value="{{$v->id}}" {{ $model->id && $v->code == $model->shipinfo->express_code ? 'selected' : '' }}>{{$v->name}}</option>
                        @endforeach
                     </select>
                 </div>
             </div>

            <div class="layui-form-item">
                <label for="" class="layui-form-label">快递号</label>
                <div class="layui-input-block">
                    <input type="text" name="express_num" value="{{$model->shipinfo->express_num}}" class="layui-input" autoComplete='off'>
                </div>
            </div>

            <div class="layui-form-item">
                <div class="layui-input-block">
                    <button type="submit" class="layui-btn preservation" lay-submit="" lay-filter="formDemo">确 认</button>
                    <!--<button class="layui-btn preservation" onclick="copy()">复制客户信息</button>-->
                    <a href="javascript:;" class="layui-btn preservation"  title="复制客户信息" onclick="copy() "> 复制客户信息</a>
                </div>
            </div>
        </form>
    </div>
</div>
@endsection

@section('script')
<script>
    function copy(){
        var textValue = document.createElement('textarea');
        textValue.setAttribute('readonly', 'readonly');
        let username = '<?php echo $model->shipinfo->name ?>';
        let mobile = '<?php echo $model->shipinfo->mobile ?>';
        let address = '<?php echo $model->shipinfo->address ?>';
        const text = ' ' + username + ' ' + mobile + ' ' + address;
        textValue.value = text;
        document.body.appendChild(textValue);
        textValue.select();
    	document.execCommand('copy');
    	document.body.removeChild(textValue);
    	layer.alert('复制成功');
    }
    layui.use(['element', 'form'], function() {
        var form = layui.form
        //监听提交
        form.on('submit(formDemo)', function(data) {
            // 禁用提交按钮
            var DISABLED = 'layui-btn-disabled';
            $('.preservation').addClass(DISABLED);
            $('.preservation').attr('disabled', 'disabled');
            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                url: "{{route('users.ship.edit')}}",
                type: 'POST',
                data: data.field,
                async: false,
                dataType: "json",
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1, time:500},function(){
                            var index = parent.layer.getFrameIndex(window.name); 
                            parent.layui.table.reload('dataTable');
                            parent.layer.close(index);
                        });
                    } else {
                        layer.msg(res.msg,{icon:2});
                        // 单击之后提交按钮不可选,防止重复提交
                        $('.preservation').removeClass(DISABLED);
                        $('.preservation').removeAttr('disabled');
                    }
                },
                // 服务器错误
                error: function(res) {
                    layer.msg('服务器错误',{icon:2});
                    // 单击之后提交按钮不可选,防止重复提交
                    $('.preservation').removeClass(DISABLED);
                    $('.preservation').removeAttr('disabled');
                }
            });
            return false;
        });
    })
</script>
@endsection