@extends('admin.base')

@section('content')
<div class="layui-card">
    
    <div class="layui-card-header layuiadmin-card-header-auto">
        <!-- form -->
        <div class="layui-form">
            <div class="layui-inline" id="datesection">
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="start_time" id="start_time" class="layui-input" placeholder="开始日期">
                </div>
                -
                <div class="layui-input-inline">
                    <input type="text" autocomplete="off" name="end_time" id="end_time" class="layui-input" placeholder="结束日期">
                </div>
            </div>
            <button class="layui-btn layuiadmin-btn-useradmin" id="searchBtn" lay-submit lay-filter="LAY-user-front-search">
                <i class="layui-icon layui-icon-search layuiadmin-button-btn"></i>
            </button>
        </div>
        <div id="order_money"></div>
        <div id='recharge_money'></div>
    </div>

    <div class="layui-card-body">
        <table id="dataTable" lay-filter="dataTable"></table>
        <!-- 头像 -->
        <script type="text/html" id="templet_thumb">
            <img class="pimg" src="@{{d.userinfo.avatar}}" style="width: 50px;height:50px;border-radius: 25px;object-fit: contain;">
        </script>
        <!-- 余额 -->
        <script type="text/html" id="templet_money">
            @{{d.userinfo.money}}<br>
            @can('users.users.edit_money')
            <div class="layui-btn-group">
                <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="edit_money">编辑 </a>
                @can('stats.money')
                <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="money_info">查看 </a>
                @endcan
            <div>
            @endcan
        </script>
        <!-- 积分 -->
        <script type="text/html" id="templet_coin">
            @{{d.userinfo.coin}}<br>
            @can('users.users.edit_money')
            <div class="layui-btn-group">
                <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="edit_coin">编辑 </a>
                @can('stats.coin')
                <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="coin_info">查看 </a>
                @endcan
            </div>
            @endcan
        </script>
        <!-- 购物金 -->
        <script type="text/html" id="templet_gold">
            @{{d.userinfo.gold}}<br>
            @can('users.users.edit_money')
            <div class="layui-btn-group">
                <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="edit_gold">编辑 </a>
                @can('stats.gold')
                <a class="layui-btn layui-btn-primary layui-btn-xs" lay-event="gold_info">查看 </a>
                @endcan
            </div>
            @endcan
        </script>
        <!-- 状态 -->
        <script type="text/html" id="templet_switch">
            <!-- 这里的 checked 的状态只是演示 -->
            <input id="checkShow" type="checkbox" name="Show" value="@{{d.id}}" lay-skin="switch" lay-text="启用|禁用" @{{ d.status == "1" ? "checked" : "" }} lay-filter="ShowDemo">
        </script>
        <!-- 表格头部 -->
        <script type="text/html" id="toolbarDemo">
            <div class="layui-table-tool-temp" style="float: left;padding-right: 20px;">
                <div class="layui-inline" lay-event="refresh"><i class="layui-icon layui-icon-refresh-3"></i></div>
            </div>
        </script>
        <!-- 操作 -->

    </div>

</div>
@endsection

@section('script')
@can('users.users')
<script>
        $.ajax({
            url: "{!! route('users.team.data',['id'=>request()->id]) !!}",
            data: {
                start_time: $("#start_time").val(),
                end_time: $("#end_time").val(),
            },
            type: 'GET',
            async: false,
            dataType: "json",
            // 接口成功请求之后的逻辑
            success: function(res) {
                console.log($('#recharge_money').text);
                $('#order_money').text('消费金额：' + res.order_money)
                $('#recharge_money').text('充值金额：' + res.recharge_money)
                // if (res.code == 200) {
                //     var optionchartZhe = res.data
                //     chartZhu.setOption(optionchartZhe, true);
                // }
            },
        });
    layui.use(['layer', 'table', 'form','laydate'], function() {
        var $ = layui.jquery;
        var layer = layui.layer;
        var form = layui.form;
        var table = layui.table;
        var laydate = layui.laydate;
        var util = layui.util;

        //用户表格初始化
        var dataTable = table.render({
            elem: '#dataTable',
            height: 'full-130',
            toolbar: '#toolbarDemo',
            limits: [20,50,100,200,500],
            limit: 20,
            url: "{!! route('users.team.data',['id'=>request()->id]) !!}",
            page: true, //开启分页
            cols: [[ //表头
                    {checkbox: true}, 
                    {field: 'id',title: 'ID',sort: true,align: 'center',minWidth: 100,templet: function(d){ return '<i><b>'+d.userinfo.id+'</b></i>';}},
                    {field: 'userinfo.avatar',title: '用户头像',align: 'center',minWidth: 100,templet: "#templet_thumb"},
                    {field: 'userinfo.nickName',title: '昵称',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.userinfo.nickName+'</b></i>';}},
                    {field: 'money',title: '消费金额',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.money+'</b></i>';}},
                    {field: 'money',title: '充值金额',align: 'center',minWidth: 150,templet: function(d){ return '<i><b>'+d.recharge_money+'</b></i>';}},
                    {field: 'userinfo.created_at',minWidth: 200,title: '创建时间',align: 'center',templet: function(d) {return util.toDateString(d.created_at*1000);}},
                    
                    // {title: '操作',align: 'center',toolbar: '#options',minWidth: 150,fixed: 'right'}
                ]],
            // 设置操作高度问题
            done: function () {
                //设置工具栏表头高度
                $(".layui-table-header").eq(1).find("table").height($(".layui-table-header").eq(0).height()+1);
                //设置工具栏按钮栏高度
                $(".layui-table").eq(1).find("tr").each(function(index,ele){
                    $(".layui-table-body").eq(1).find("tr").eq(index).height($(ele).height());
                });
            }
        });

        //日期范围
        laydate.render({
            elem: '#datesection'
            ,range: ['#start_time', '#end_time']
        });

        // 头部工具
        table.on('toolbar(dataTable)', function (obj) {
            switch (obj.event) {
                // 添加
                case 'add':
                    break;
                // 批量删除
                case 'delete':
                    break;
                // 刷新
                case 'refresh':
                    table.reload("dataTable",{page:{curr:$(".layui-laypage-em").next().html()}});
                    break;
                }
        });

        //监听工具条
        table.on('tool(dataTable)', function(obj) { //注：tool是工具条事件名，dataTable是table原始容器的属性 lay-filter="对应的值"
            var data = obj.data,
                layEvent = obj.event; //获得 lay-event 对应的值
            if (layEvent === 'edit') {
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '80%'],
                    content: "{{route('users.users.store')}}?id="+data.id
                });
            }else if(layEvent === 'edit_money'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '80%'],
                    content: "{{route('users.users.edit_money')}}?id="+data.id+'&money_type=1'
                });
            }else if(layEvent === 'edit_coin'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '80%'],
                    content: "{{route('users.users.edit_money')}}?id="+data.id+'&money_type=2'
                });
            }else if(layEvent === 'edit_gold'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['60%', '80%'],
                    content: "{{route('users.users.edit_money')}}?id="+data.id+'&money_type=3'
                });
            }else if(layEvent === 'money_info'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['90%', '90%'],
                    content: "{{route('stats.money')}}?id="+data.id
                });
            }else if(layEvent === 'coin_info'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['90%', '90%'],
                    content: "{{route('stats.coin')}}?id="+data.id
                });
            }else if(layEvent === 'gold_info'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['90%', '90%'],
                    content: "{{route('stats.gold')}}?id="+data.id
                });
            }else if(layEvent === 'user_box'){
                layer.open({
                    type: 2,
                    shade: 0.8,
                    area: ['95%', '95%'],
                    content: "{{route('stats.box')}}?id="+data.id
                });
            }else if(layEvent === 'team'){
                layer.open({
                    type: 2,
                    shade :0.8,
                    area:['95%','95%'],
                    content: "{{route('users.users')}}?id="+data.id
                })
            }
        });

        //监听状态操作
        form.on('switch(ShowDemo)', function (data) {
            var swithcData = data;
            var id = data.value;// 获取要修改的ID
            $.ajax({
                type: 'POST',
                url: "{{route('users.users.show')}}",
                data: {"id": id,},
                // 接口成功请求之后的逻辑
                success: function(res) {
                    if (res['code'] == 200) {
                        // 弹窗
                        layer.msg(res.msg, { icon: 1});
                    } else {
                        layer.msg(res.msg, {icon: 2});
                    }
                },
                // 服务器错误
                error: function(res) {
                    // 弹窗
                    layer.msg('服务器错误', {icon: 2});
                }
            });
        });

        //搜索
        $("#searchBtn").click(function() {
            dataTable.reload({
                where: {
                    id: $("#id").val(),
                    nickName: $("#nickName").val(),
                    status: $("#status").val(),
                    start_time: $("#start_time").val(),
                    end_time: $("#end_time").val(),
                },
                page: {curr: $(".layui-laypage-em").next().html()}
            })
            $.ajax({
            url: "{!! route('users.team.data',['id'=>request()->id]) !!}",
            data: {
                start_time: $("#start_time").val(),
                end_time: $("#end_time").val(),
            },
            type: 'GET',
            async: false,
            dataType: "json",
            // 接口成功请求之后的逻辑
            success: function(res) {
                console.log($('#recharge_money').text);
                $('#order_money').text('消费金额：' + res.order_money)
                $('#recharge_money').text('充值金额：' + res.recharge_money)
                // if (res.code == 200) {
                //     var optionchartZhe = res.data
                //     chartZhu.setOption(optionchartZhe, true);
                // }
            },
        });
        })
    })
</script>
@endcan
@endsection