<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
//允许请求来自哪些域名
header('Access-Control-Allow-Origin: *');
//允许请求中携带cookie
header("Access-Control-Allow-Credentials: true");
//允许请求采用哪些请求方式
header("Access-Control-Allow-Methods: *");
//允许请求中包含哪些header
header("Access-Control-Allow-Headers: *");
//自定义的请求头token
header("Access-Control-Expose-Headers: *");

// 支付回调
Route::any('v1/wxpay/notify', 'Api\V1\Pay\WxNotifyController@notify');                                                 // 微信回调
Route::any('v1/alipay/notify', 'Api\V1\Pay\AliNotifyController@notify');                                                 // 支付宝回调
// 不需要登陆
Route::any('v1/index', 'Api\V1\Index\IndexController@index');                                                           // 首页
// 上传
Route::any('v1/upload/image', 'Api\V1\Index\UploadsController@image');                                                       // 图片上传
Route::any('v1/share', 'Api\V1\Index\ShareController@share');                                                           // 邀请链接
//需要登录
Route::group(['prefix' => 'v1', 'namespace' => 'Api\V1', 'middleware' =>  ['signature']], function () {

    // -------------------公共-------------------
    // 短信发送
    Route::post('sms/send', 'Sms\SmsController@send');                                                                  // 短信发送

    // 规则协议
    Route::post('sysrule', 'Index\SysRuleController@index');                                                            // 规则协议
    // 配置
    Route::post('config/global', 'Index\ConfigController@global');                                                      // 全局配置
    Route::post('config/redpack', 'Index\ConfigController@redpack')->middleware('apiToken');                            // 红包配置
    // -------------------用户-------------------
    // 注册登录
    Route::post('user/register', 'User\RegisterController@register');                                                   // 注册
    Route::post('user/login', 'User\LoginController@login');                                                            // 用户登录
    Route::post('user/testLogin', 'User\LoginController@testLogin');                                                    // 用户登录(测试)
    Route::get('user/ts', 'User\LoginController@ts');
    Route::get('user/sendCustomMessage', 'User\LoginController@sendCustomMessage');
    Route::post('user/Messagepost', 'User\LoginController@Messagepost');
    Route::get('user/epaynotify', 'User\LoginController@epaynotify');
    Route::post('user/cxorder', 'User\LoginController@cxorder');
    Route::get('user/notify', 'User\LoginController@notify');
    // 用户信息
    Route::post('user/info', 'User\UserController@info')->middleware('apiToken');                                       // 用户信息
    Route::post('user/myteam', 'User\UserController@myTeam')->middleware('apiToken');                                       // 用户信息
    Route::post('user/bind', 'User\BindController@list')->middleware('apiToken');                                       // 邀请记录
    Route::post('user/info/edit', 'User\UserController@updateInfo')->middleware('apiToken');                            // 修改用户信息
    Route::post('user/updateMobile', 'User\UserController@updateMobile')->middleware('apiToken');                       // 更新手机号
    Route::post('user/setdaili','User\DailiController@setDaili')->middleware('apiToken');                               // 申请代理
    // 用户明细
    Route::post('user/money/list', 'User\MoneyController@money')->middleware('apiToken');                               // 余额明细
    Route::post('user/coin/list', 'User\MoneyController@coin')->middleware('apiToken');                                 // 积分明细
    Route::post('user/gold/list', 'User\MoneyController@gold')->middleware('apiToken');                                 // 购物金明细
    // 提现
    Route::post('user/withdraw/apply', 'User\WithdrawController@apply')->middleware('apiToken');                        // 申请提现
    Route::post('user/withdraw/log', 'User\WithdrawController@log')->middleware('apiToken');                            // 提现记录
    //充值
    Route::post('user/recharge', 'User\RechargeController@getRechargeRate');                                            // 充值列表
    Route::post('user/recharge/gopay', 'User\RechargeController@goPay');                                            // 充值支付
    // 盒柜
    Route::post('user/award', 'Ship\BoxController@list')->middleware('apiToken');                                       // 盒柜
    Route::post('user/ship/box', 'Ship\BoxController@order')->middleware('apiToken');                                   // 发货
    Route::post('user/ship/box/info', 'Ship\BoxController@info')->middleware('apiToken');                               // 发货详情
    Route::post('user/ship/box/express', 'Ship\BoxController@express')->middleware('apiToken');                         // 快递详情
    Route::post('user/ship/box/receipt', 'Ship\BoxController@receipt')->middleware('apiToken');                         // 确认收货
    Route::post('user/ship/box/dissolve', 'Ship\BoxController@dissolve')->middleware('apiToken');                         // 退货
    Route::post('user/ship/box/rating', 'Ship\BoxController@rating')->middleware('apiToken');                           // 评价
    // 地址
    Route::post('address/list', 'User\AddressController@list');                                                         // 地址列表
    Route::post('address/store', 'User\AddressController@store')->middleware('apiToken');                               // 地址添加
    Route::post('address/default', 'User\AddressController@default')->middleware('apiToken');                           // 地址设置默认
    Route::post('address/del', 'User\AddressController@del')->middleware('apiToken');                                   // 地址删除
    Route::post('address/data', 'User\AddressController@data')->middleware('apiToken');                                 // 默认地址
    Route::post('address/info', 'User\AddressController@info')->middleware('apiToken');                                 // 地址详情
    // -------------------运营管理-------------------
    Route::post('operate/banners', 'Operate\BannersController@list');                                                   // 轮播图列表
    Route::post('operate/banners/info', 'Operate\BannersController@info');                                              // 轮播图详情
    // -------------------商城管理-------------------
    Route::post('shop/cat', 'Shop\CatController@list');                                                                 // 商品分类
    Route::post('shop/brand', 'Shop\BrandController@list');                                                             // 商品品牌
    Route::post('shop/hotsearch', 'Shop\HotsearchController@list');                                                     // 热门搜索
    Route::post('shop/list', 'Shop\GoodsController@list');                                                              // 商品列表
    Route::post('shop/info', 'Shop\GoodsController@info');                                                              // 商品详情
    Route::post('shop/collect', 'Shop\GoodsController@collect')->middleware('apiToken');                                // 商品收藏，取消
    Route::post('shop/order', 'Shop\OrderController@order')->middleware('apiToken');                                    // 商品确认提交订单
    Route::post('shop/ship/order', 'Ship\ShopController@list')->middleware('apiToken');                                 // 商城订单列表
    Route::post('shop/ship/info', 'Ship\ShopController@info')->middleware('apiToken');                                  // 商城订单详情
    Route::post('shop/ship/express', 'Ship\ShopController@express')->middleware('apiToken');                            // 商城订单物流
    Route::post('shop/ship/receipt', 'Ship\ShopController@receipt')->middleware('apiToken');                            // 商城订单确认收货
    // 置换商城
    Route::post('shop/change/list', 'Shop\ChangeController@list');                                                      // 置换商品列表
    Route::post('shop/change/info', 'Shop\ChangeController@info');                                                      // 置换商品详情
    // -------------------抽盒管理-------------------
    Route::post('box/mark', 'Box\MarkController@list');                                                                 // 赏等级
    Route::post('box/log', 'Box\LogController@list');                                                                   // 中奖记录
    Route::post('box/draw', 'Box\DrawController@list');                                                                 // 抽取方式
    Route::post('box/list', 'Box\BoxController@list');                                                                  // 盒子列表
    Route::post('box/award', 'Box\AwardController@award');                                                              // 盒子奖品
    Route::post('box/info', 'Box\BoxController@info');                                                                  // 盒子详情
    Route::post('box/rating', 'Box\RatingController@list');                                                             // 盒子评价
    Route::post('box/order', 'Box\OrderController@order')->middleware('apiToken');                                      // 确认，提交订单
    Route::post('box/get_order_status', 'Box\OrderController@orderStatus')->middleware('apiToken');                                      // 确认，提交订单
    Route::post('box/order/award', 'Box\AwardController@list')->middleware('apiToken');                                 // 中奖奖品
    Route::post('box/order/tryplay', 'Box\OrderController@tryplay');                                                    // 试玩
    Route::post('box/friend/log', 'Box\FriendController@list');                                                         // 开盒记录
    // -------------------幸运盲盒-------------------
    Route::post('luckbox/config', 'Luckbox\ConfigController@index')->middleware('apiToken');                            // 幸运盲盒配置
    Route::post('luckbox/log', 'Luckbox\LogController@list')->middleware('apiToken');                                   // 幸运盲盒中奖记录
    Route::post('luckbox/log/info', 'Luckbox\LogController@info')->middleware('apiToken');                              // 幸运盲盒中奖详情
    Route::post('luckbox/award', 'Luckbox\AwardController@list');                                                       // 幸运盲盒普通奖品
    Route::post('luckbox/index', 'Luckbox\BoxController@index')->middleware('apiToken');                                // 幸运盲盒首页
    Route::post('luckbox/join', 'Luckbox\JoinController@join')->middleware('apiToken');                                 // 幸运盲盒兑换盒子
    Route::post('luckbox/task/info', 'Luckbox\TaskController@index')->middleware('apiToken');                           // 幸运盲盒签到任务
    Route::post('luckbox/sign', 'Luckbox\SignController@sign')->middleware('apiToken');                                 // 幸运盲盒签到
    Route::post('luckbox/hide/receive', 'Luckbox\HideController@receive')->middleware('apiToken');                      // 幸运盲盒隐藏领取
    Route::post('luckbox/share/poster', 'Luckbox\ShareController@poster')->middleware('apiToken');                      // 幸运盲盒分享海报
    // -------------------投诉-------------------
    Route::post('complain/type', 'Complain\TypeController@list');                                                       // 投诉分类
    Route::post('complain/add', 'Complain\ComplainController@add')->middleware('apiToken');                             // 投诉提交
    Route::post('complain/log', 'Complain\LogController@list')->middleware('apiToken');                                 // 投诉记录
    // -------------------红包-------------------
    Route::post('redpack/open', 'Redpack\OpenController@open');                                                         // 开红包
    // -------------------支付-------------------
    Route::post('pay/pay', 'Pay\PayController@pay')->middleware('apiToken');                                            // 微信支付
    Route::post('pay/rechargepay', 'Pay\PayController@RechargePay')->middleware('apiToken');                                            // 充值支付
    Route::post('pay/cancel', 'Pay\PayController@cancel')->middleware('apiToken');                                      // 取消支付
});
